import os
import shutil
import xml
import xml.etree.ElementTree as ET
import argparse

parser = argparse.ArgumentParser(description='Copy configuration whit new ID')
parser.add_argument('source', help='path of source configuration')
parser.add_argument('result', help='path of result configuration')
parser.add_argument('uid', help='new uid')
args = parser.parse_args()

def new_from_prev(prev_uid, simple_id):
    if prev_uid is None or prev_uid[0]=='\n' or prev_uid=="-1":
        return prev_uid;
    if simple_id:
        return args.uid;
    else:
        return args.uid+prev_uid[len(prev_uid)-6:];

if not os.path.exists(args.result):
    os.makedirs(args.result)
shutil.rmtree(args.result)

for root, dirs, files in os.walk(args.source):
    root_dir = os.path.split(root)[1] 
    is_datastorage = root_dir=='datastorages'
    is_simple_id = is_datastorage or root_dir==''
    
    for file_name in files:
        name, ext = os.path.splitext(file_name)
        parts = name.split('_')
        new_uid = new_from_prev(parts[-1], is_simple_id)
        if is_datastorage:
            parts[-2] = new_uid
        else:
            parts[-1] = new_uid
        new_name = '_'.join(parts) + ext

        new_root = os.path.join(args.result, root_dir)
        if not os.path.exists(new_root):
            os.makedirs(new_root);
            
        tree = ET.parse(os.path.join(root, file_name))
        xml = tree.getroot();
        simple_tags = "ID", "Arm", "Channel", "ServerId", "AntennaUid", "LocationID", \
                      "PoolID", "ChannelServerId", "AntennaRpuId", "Uid", "Pelengator", \
                      "Antenna", "Transmitter", "Receiver", "DefaultPelengatorUid", \
                      "ReceiverBoxId", "ControlUid"
        for tag in simple_tags:
            for uid in xml.iter(tag):
                uid.text = new_from_prev(uid.text, is_simple_id)

        if is_datastorage:
            '''for uid in xml.iter("DSUID"):
                uid.text = new_from_prev(uid.text, True)'''
            for uid in xml.iter("ArmUID"):
                uid.text = new_from_prev(uid.text, False)
        else:
            '''for uid in xml.iter("DataStorage"):
                uid.text = new_from_prev(uid.text, True)
            for uid in xml.iter("PrimaryDBUid"):
                uid.text = new_from_prev(uid.text, True)'''

        tree.write(os.path.join(new_root, new_name), "UTF-8", True)